package gov.va.genisis2.vo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Class EmailDetailsTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class EmailDetailsTest.
 * 
 *          Description: In this EmailDetailsTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */
public class EmailDetailsTest {

	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(EmailDetailsTest.class);

	/**
	 * Test email details.
	 */
	@Test
	public void testEmailDetails() {
		LOGGER.info("**********Junit Test Email Details**********");
		EmailDetails emailDetails = new EmailDetails();

		assertNull(emailDetails.getFrom());
		assertNull(emailDetails.getTo());
		assertNull(emailDetails.getSubject());
		assertNull(emailDetails.getBody());
		assertNull(emailDetails.getPeople());
		assertNull(emailDetails.getCc());
		
		emailDetails.setFrom("from");
		emailDetails.setTo("to");
		emailDetails.setSubject("subject");
		emailDetails.setBody("body");
		emailDetails.setPeople("people");
		emailDetails.setCc("cc");

		assertEquals("from", emailDetails.getFrom());
		assertEquals("to", emailDetails.getTo());
		assertEquals("subject", emailDetails.getSubject());
		assertEquals("body", emailDetails.getBody());
		assertEquals("people", emailDetails.getPeople());
		assertEquals("cc", emailDetails.getCc());
		
		emailDetails = new EmailDetails("from", "to", "subject", "body");

		assertEquals("from", emailDetails.getFrom());
		assertEquals("to", emailDetails.getTo());
		assertEquals("subject", emailDetails.getSubject());
		assertEquals("body", emailDetails.getBody());
		assertNull(emailDetails.getPeople());

		emailDetails = new EmailDetails("from", "to", "subject", "body", "cc");

		assertEquals("from", emailDetails.getFrom());
		assertEquals("to", emailDetails.getTo());
		assertEquals("subject", emailDetails.getSubject());
		assertEquals("body", emailDetails.getBody());
		assertEquals("cc", emailDetails.getCc());

		LOGGER.info("**********End of Test Junit Email Details**********");
	}
}
